varying vec4 lmtexcoord;
varying vec4 color;
varying vec2 normalMatCompressed;

#define diagonal3(m) vec3(m[0].x, m[1].y, m[2].z)
#define projMAD(m, v) (diagonal3(m) * (v) + m[3].xyz)

#include "/lib/vertex/main.glsl"

void main()
{
    vec2 lmNorm = clamp((gl_MultiTexCoord1.xy - 8.0) / 247, 0.0, 1.0);
    lmtexcoord = vec4(gl_MultiTexCoord0.xy, lmNorm);
    color = gl_Color;

    normalMatCompressed = encodeNormal(gl_Normal);

#if defined(NO_ENTITY_TAA)
    gl_Position = toClipSpace4((mat3(gl_ModelViewMatrix) * gl_Vertex.xyz) + gl_ModelViewMatrix[3].xyz);
#else
    vec4 viewPos = gl_ModelViewMatrix * gl_Vertex;
    gl_Position = taaFunc(vec4(projMAD(gl_ProjectionMatrix, viewPos.xyz), -viewPos.z));
#endif
}